/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.panel.pa.manual;

import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ErrorListBean
extends PanelBean {
    private static final String TABLE_NAME = "ErrorTable";
    private static final String TRACE_MASKT = "XPAXELBT";
    private static final String TRACE_MASKF = "XPAXELBF";
    private static final String TRACE_MASKD = "XPAXELBD";
    private String m_sBegTimeOutput;
    private String m_sEndTimeOutput;
    private ItemDescriptor[] m_idErrorTable;
    private ColumnDescriptor[] m_cdErrorTableStructure;
    private int[] m_iErrorTableSelection;
    private List content = new ArrayList();

    public void setBeginningTimeOutput(String beginningTimeOutput) {
        this.m_sBegTimeOutput = beginningTimeOutput;
    }

    public void endBeginningTimeOutput(String endingTimeOutput) {
        this.m_sEndTimeOutput = endingTimeOutput;
    }

    public void addDataRow(String system, String area, int problemCount) {
        Trace.trace(TRACE_MASKT, "{ErrorListBean} addDataRow(" + system + "," + area + "," + problemCount + ").");
        this.content.add(new ContentElement(system, area, problemCount));
    }

    public void prepare() {
        super.prepare();
        this.userTaskManager.setShown("ViewAllButton", false);
    }

    public void panelAction(TaskActionEvent event) {
        if (event.getActionCommand().equals("CANCEL")) {
            this.dispose();
        } else {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("event", event);
            int[] selectedRows = this.userTaskManager.getSelectedRows(TABLE_NAME);
            ContentElement ce = selectedRows.length > 0 ? (ContentElement)this.content.get(selectedRows[0]) : (ContentElement)this.content.get(0);
            request.setData("system", ce.system);
            request.setData("area", ce.area);
            request.setData("command", event.getActionCommand());
            this.postTaskletRequest(request);
        }
    }

    public String getBegTimeOutput() {
        return this.m_sBegTimeOutput;
    }

    public void setBegTimeOutput(String s) throws IllegalUserDataException {
        this.m_sBegTimeOutput = s;
    }

    public String getEndTimeOutput() {
        return this.m_sEndTimeOutput;
    }

    public void setEndTimeOutput(String s) throws IllegalUserDataException {
        this.m_sEndTimeOutput = s;
    }

    public ColumnDescriptor[] getErrorTableRowStructure() {
        return this.m_cdErrorTableStructure;
    }

    public int getErrorTableRowStatus() {
        return 3;
    }

    public int getErrorTableRowCount() {
        return this.content.size();
    }

    public ItemDescriptor[] getErrorTableRowAt(int index) {
        ContentElement ce = (ContentElement)this.content.get(index);
        return new ItemDescriptor[]{new ItemDescriptor("system." + index, ce.system), new ItemDescriptor("area." + index, ce.area), new ItemDescriptor("problemCount." + index, Integer.toString(ce.problemCount))};
    }

    public void setErrorTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idErrorTable = items;
    }

    public int[] getErrorTableSelection() {
        return this.m_iErrorTableSelection;
    }

    public void setErrorTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iErrorTableSelection = selected;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public void load() {
        this.m_idErrorTable = new ItemDescriptor[0];
        this.m_cdErrorTableStructure = new ColumnDescriptor[0];
        this.m_iErrorTableSelection = new int[0];
    }

    public class ContentElement
    implements Serializable {
        public String system;
        public String area;
        public int problemCount;

        ContentElement(String system, String area, int problemCount) {
            this.system = system;
            this.area = area;
            this.problemCount = problemCount;
        }
    }
}

